#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
int16_t y1[ 3 ][ 2 ] = { 1, 2, 3, 4, 5, 6 };              /* Non-compliant */
int16_t y2[ 3 ][ 2 ] = { { 1, 2 }, { 0 }, { 5, 6 } };     /* Compliant     */
int16_t y3[ 3 ][ 2 ] = { { 1, 2 }, { 0, 0 }, { 5, 6 } };  /* Compliant     */

int16_t z1[ 2 ][ 2 ] = { { 0 }, [ 1 ][ 1 ] = 1 };         /* Compliant     */
int16_t z2[ 2 ][ 2 ] = { { 0 },
                         [ 1 ][ 1 ] = 1, [ 1 ][ 0 ] = 0
                       };                                 /* Compliant     */
int16_t z3[ 2 ][ 2 ] = { { 0 }, [ 1 ][ 0 ] = 0, 1 };      /* Non-compliant */
int16_t z4[ 2 ][ 2 ] = { [ 0 ][ 1 ] = 0, { 0, 1 } };      /* Compliant     */

float32_t a1[ 3 ][ 2 ] = { 0 };                           /* Compliant     */
float32_t a2[ 3 ][ 2 ] = { { 0 }, { 0 }, { 0 }};          /* Compliant     */
float32_t a3[ 3 ][ 2 ] = { { 0.0f, 0.0f },
                           { 0.0f, 0.0f },
                           { 0.0f, 0.0f }
                         };                               /* Compliant     */

union u1 {
  int16_t   i;
  float32_t f;
} u = { 0 };                                              /* Compliant     */

struct s1 {
  uint16_t len;
  char     buf[ 8 ];
} s[ 3 ] = {
    { 5u, { 'a','b','c','d','e','\0','\0','\0' } },
    { 2u, { 0 } },
    { .len = 0u }                /* Compliant - buf initialized implicitly */
};                               /* Compliant - s[ ] fully initialized     */
// Example code from MISRA C:2012 end
